// app/about/AboutClient.tsx
"use client";

import { Suspense } from "react";
import InnerBanner from "@/components/InnerBanner";
import AboutSection from "./components/AboutSection";
import CounterSection from "./components/CounterSection";
import VisionSection from "./components/VisionSection";
import KeyBenefitsSection from "@/components/KeyBenefitsSection";
import TestimonialsSection from "@/components/TestimonialsSection";
import "./about.css";

function PageLoader() {
    return (
        <div className="min-vh-100 d-flex align-items-center justify-content-center">
            <div className="spinner-border text-primary" />
        </div>
    );
}

export default function AboutClient({
    breadcrumbHeadline,
    aboutData,
    counterData,
    visionData,
    keyBenefitsData,
    testimonialsData,
}: any) {
    return (
        <Suspense fallback={<PageLoader />}>
            <InnerBanner
                title={breadcrumbHeadline}
                breadcrumb={breadcrumbHeadline}
            />

            <AboutSection data={aboutData} />
            <CounterSection data={counterData} />
            <VisionSection data={visionData} />
            <KeyBenefitsSection data={keyBenefitsData} />
            <TestimonialsSection data={testimonialsData} />
        </Suspense>
    );
}
