"use client";

import { motion } from "framer-motion";

export default function BrandSection() {
  const icons = ["icon-5.png", "icon-6.png", "icon-7.png", "icon-8.png", "icon-9.png"];

  return (
    <section className="brand-sec py-4">
      <div className="container">
        <div className="row text-center">

          {icons.map((icon, i) => (
            <motion.div
              key={i}
              className="col-lg-2 col-md-3 col-4 mb-3"
              initial={{ opacity: 0, scale: 0.7 }}
              whileInView={{ opacity: 1, scale: 1 }}
              transition={{ delay: i * 0.1 }}
            >
              <img src={`/images/${icon}`} className="img-fluid brand-img" alt={`Brand icon ${i + 1}`} width="100" height="100" loading="lazy" />
            </motion.div>
          ))}

        </div>
      </div>
    </section>
  );
}
