"use client";

import React, { useEffect, useMemo, useState } from "react";
import { getToken } from "@/lib/apiEndpoints";
import Link from "next/link";
import InnerBanner from "../../components/InnerBanner";
import { useCart } from "@/context/CartContext";


export default function CartPage() {
    const { items, isLoading, changeQty, removeFromCart } = useCart();
    const isLoggedIn = !!getToken();

    // Load FontAwesome
    useEffect(() => {
        const link = document.createElement('link');
        link.rel = 'stylesheet';
        link.href = 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css';
        document.head.appendChild(link);
        return () => {
            document.head.removeChild(link);
        };
    }, []);

    const total = useMemo(() => items.reduce((s, it) => s + it.price * it.qty, 0), [items]);

    return (
        <div>
            <InnerBanner title="Shopping Cart" breadcrumb="Cart" />

            <div className="container py-5">
                <div className="card shadow-sm border-0">
                    <div className="card-body p-4">
                        {isLoading ? (
                            <div className="text-center py-5">
                                <div
                                    className="spinner-border"
                                    role="status"
                                    style={{ color: "#2f80ff", width: "3rem", height: "3rem" }}
                                >
                                    <span className="visually-hidden">Loading...</span>
                                </div>
                                <p className="mt-3 text-muted">Loading your cart...</p>
                            </div>
                        ) : items.length === 0 ? (
                            <div className="text-center py-5">
                                <i className="fa-solid fa-cart-shopping fa-3x" style={{ color: '#2f80ff' }}></i>
                                <p className="mt-3 text-muted">Your cart is empty.</p>
                            </div>
                        ) : (
                            <>
                                <div className="table-responsive">
                                    <table className="table align-middle table-hover">
                                        <thead style={{ backgroundColor: '#2f80ff', color: 'white' }}>
                                            <tr>
                                                <th className="border-0">Product</th>
                                                <th className="text-end border-0">Price</th>
                                                <th className="text-center border-0">Quantity</th>
                                                <th className="text-end border-0">Subtotal</th>
                                                <th className="border-0"></th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            {items.map((it) => (
                                                <tr key={it.id}>
                                                    <td>
                                                        <div className="d-flex align-items-center">
                                                            <img
                                                                src={it.img}
                                                                alt={it.name}
                                                                style={{
                                                                    width: "60px",
                                                                    height: "60px",
                                                                    objectFit: "cover",
                                                                    borderRadius: "8px",
                                                                    marginRight: "12px",
                                                                }}
                                                            />
                                                            <div className="fw-semibold">{it.name}</div>
                                                        </div>
                                                    </td>

                                                    <td className="text-end">₹{it.price}</td>

                                                    <td className="text-center">
                                                        <div className="d-inline-flex align-items-center border rounded-pill px-2 py-1">
                                                            <button
                                                                className="btn btn-sm p-1"
                                                                style={{ color: '#2f80ff', border: 'none' }}
                                                                onClick={() => changeQty(it.id, -1)}
                                                            >
                                                                <i className="fa-solid fa-minus"></i>
                                                            </button>

                                                            <span className="mx-3 fw-semibold">{it.qty}</span>

                                                            <button
                                                                className="btn btn-sm p-1"
                                                                style={{ color: '#2f80ff', border: 'none' }}
                                                                onClick={() => changeQty(it.id, 1)}
                                                            >
                                                                <i className="fa-solid fa-plus"></i>
                                                            </button>
                                                        </div>
                                                    </td>

                                                    <td className="text-end fw-semibold">₹{it.price * it.qty}</td>

                                                    <td className="text-end">
                                                        <button
                                                            className="btn btn-sm btn-danger"
                                                            onClick={() => removeFromCart(it.id)}
                                                        >
                                                            <i className="fa-solid fa-trash"></i>
                                                        </button>
                                                    </td>
                                                </tr>
                                            ))}
                                        </tbody>
                                    </table>
                                </div>
                                <div className="d-flex justify-content-between align-items-center mt-4 pt-4 border-top">
                                    <div>
                                        {/* <button
                                            className="btn me-2"
                                            style={{
                                                borderColor: '#2f80ff',
                                                color: '#2f80ff',
                                                backgroundColor: 'white',
                                                border: '1px solid #2f80ff'
                                            }}
                                        >
                                            <i className="fa-regular fa-heart me-2"></i>Save for Later
                                        </button> */}

                                        <Link href="/" className="btn btn-outline-dark">
                                            <i className="fa-solid fa-arrow-left me-2"></i>Continue Shopping
                                        </Link>
                                    </div>

                                    <div className="text-end">
                                        <div className="mb-3">
                                            <span className="text-muted">Total:</span>
                                            <h4 className="d-inline-block mb-0 ms-2" style={{ color: '#000' }}>
                                                ₹{total}
                                            </h4>
                                        </div>

                                        {isLoggedIn ? (
                                            <Link
                                                href="/checkout"
                                                className="btn btn-lg text-white"
                                                style={{
                                                    backgroundColor: '#2f80ff',
                                                    border: 'none',
                                                }}
                                            >
                                                <i className="fa-solid fa-bag-shopping me-2"></i>Checkout
                                            </Link>
                                        ) : (
                                            <Link
                                                href="/login"
                                                className="btn btn-lg text-white"
                                                style={{
                                                    backgroundColor: '#2f80ff',
                                                    border: 'none',
                                                }}
                                            >
                                                <i className="fa-solid fa-bag-shopping me-2"></i>Checkout
                                            </Link>
                                        )}
                                    </div>
                                </div>
                            </>
                        )}
                    </div>
                </div>
            </div>
        </div>
    );
}