"use client";

import React from "react";
import InnerBanner from "../../components/InnerBanner";

interface CoverPageClientProps {
    pageData: any;
    sectionData: any;
    coverPage: { top_banner_files: any[]; files: any[]; };
}

export default function CoverPageClient({ pageData, sectionData, coverPage }: CoverPageClientProps) {
    const breadcrumbHeadline = pageData?.breadcrumb_headline || "Free Downloads";
    const headline = sectionData?.section_headline || "";
    const description = sectionData?.description || "";

    return (
        <div>
            <InnerBanner title={breadcrumbHeadline} breadcrumb={breadcrumbHeadline} />

            <div className="container py-5">

                {/* Top Banners */}
                {coverPage?.top_banner_files?.length > 0 && (
                    <div className="row g-4 mb-5">
                        {coverPage.top_banner_files.map((item, index) => (
                            <div key={index} className="col-md-6">
                                <div
                                    className="p-5 text-center rounded-4 shadow-sm"
                                    style={{ backgroundColor: "#eef6ff", border: "1px solid #dbeafe" }}
                                >
                                    <h5 className="fw-bold mb-4 text-dark">
                                        {item.file_name}
                                    </h5>

                                    <a
                                        href={item.file}
                                        target="_blank"
                                        rel="noopener noreferrer"
                                        className="btn text-white fw-bold px-4 py-2 rounded-pill shadow-sm hover-scale"
                                        style={{ backgroundColor: "#2f80ff", border: "none" }}
                                    >
                                        DOWNLOAD
                                    </a>
                                </div>
                            </div>
                        ))}
                    </div>
                )}

                {/* Section Title */}
                <div className="text-center mb-5">
                    <h3 className="fw-bold">{headline}</h3>
                    <div className="text-primary fw-bold" dangerouslySetInnerHTML={{ __html: description }} />
                </div>

                {/* Resources Grid */}
                {coverPage?.files?.length > 0 ? (
                    <div className="row g-4">
                        {coverPage.files.map((item, index) => (
                            <div key={index} className="col-12 col-sm-6 col-md-4 col-lg-3">
                                <div
                                    className="card border-0 shadow-sm h-100 p-3 text-center rounded-4 hover-lift"
                                    style={{ transition: "all 0.3s" }}
                                >
                                    <div className="card-body d-flex flex-column justify-content-center align-items-center">
                                        <div className="mb-3 p-3 rounded-circle bg-light text-primary">
                                            <i className="fa-solid fa-file-pdf fa-2x"></i>
                                        </div>

                                        <h6 className="fw-bold mb-4">{item.file_name}</h6>

                                        <div className="d-flex gap-2 mt-auto w-100 justify-content-center">
                                            <a
                                                href={item.file}
                                                target="_blank"
                                                rel="noopener noreferrer"
                                                className="btn btn-outline-primary fw-bold px-3 py-2 rounded-pill shadow-sm flex-fill"
                                                style={{ fontSize: "14px" }}
                                            >
                                                VIEW
                                            </a>

                                            <a
                                                href={item.file}
                                                target="_blank"
                                                rel="noopener noreferrer"
                                                className="btn text-white fw-bold px-3 py-2 rounded-pill shadow-sm flex-fill"
                                                style={{
                                                    backgroundColor: "#2f80ff",
                                                    border: "none",
                                                    fontSize: "14px",
                                                }}
                                            >
                                                DOWNLOAD
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        ))}
                    </div>
                ) : (
                    <p className="text-center text-muted">
                        No free files available at the moment.
                    </p>
                )}

                <style jsx>{`
                    .hover-scale:hover {
                        transform: scale(1.05);
                        transition: transform 0.2s;
                    }
                    .hover-lift:hover {
                        transform: translateY(-5px);
                        box-shadow: 0 .5rem 1rem rgba(0,0,0,.15)!important;
                    }
                `}</style>
            </div>
        </div>
    );
}
