import { API_ENDPOINTS } from "@/lib/apiEndpoints";
import { Metadata } from "next";
import GuessPapersClient from "./GuessPapersClient";
import { buildGuessPaperListMeta } from "@/lib/seo/guessPaperMeta";

export const dynamic = "force-dynamic";

async function fetchGuessPapersData() {
    try {
        const [res, res1] = await Promise.all([
            API_ENDPOINTS.PAGE(13),
            API_ENDPOINTS.GUESS_PAPERS.CATEGORIES_COURSES(),
        ]);

        if (!res.ok) throw new Error(`HTTP ${res.status}`);
        if (!res1.ok) throw new Error(`HTTP ${res1.status}`);

        const [pageData, categoriesData] = await Promise.all([
            res.json(),
            res1.json(),
        ]);

        return {
            pageData,
            allCategories: categoriesData.categories || [],
        };
    } catch (err: any) {
        console.error("❌ Failed to load guess papers data", err);
        return null;
    }
}

export async function generateMetadata(): Promise<Metadata> {
    const data = await fetchGuessPapersData();
    if (!data || !data.pageData) return { title: "Guess Papers" };
    return buildGuessPaperListMeta(data.pageData);
}

export default async function GuessPapersPage() {
    const data = await fetchGuessPapersData();

    if (!data) {
        return <div className="text-danger text-center py-5">Failed to load guess papers.</div>;
    }

    return (
        <GuessPapersClient
            pageData={data.pageData}
            allCategories={data.allCategories}
        />
    );
}
