import React, { Suspense } from "react";
import InnerBanner from "@/components/InnerBanner";
import OrderFailedClient from "@/components/OrderFailedClient";

export default function OrderFailedPage() {
    return (
        <>
            <style>{`
                .order-status-card {
                    background: #fff;
                    border-radius: 12px;
                    padding: 40px;
                    max-width: 500px;
                    margin: auto;
                    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
                }

                .order-status-card.failed {
                    border-top: 6px solid #dc3545;
                }
            `}</style>

            <InnerBanner title="Order Failed" breadcrumb="Order Failed" />

            <section className="py-5">
                <div className="container text-center">
                    <Suspense fallback={<div>Loading...</div>}>
                        <OrderFailedClient />
                    </Suspense>
                </div>
            </section>
        </>
    );
}
