import React, { Suspense } from "react";
import InnerBanner from "@/components/InnerBanner";
import OrderPendingClient from "@/components/OrderPendingClient";

export default function OrderPendingPage() {
    return (
        <>
            <style>{`
                .order-status-card {
                    background: #fff;
                    border-radius: 12px;
                    padding: 40px;
                    max-width: 500px;
                    margin: auto;
                    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
                }

                .order-status-card.pending {
                    border-top: 6px solid #ffc107;
                }
            `}</style>

            <InnerBanner title="Order Pending" breadcrumb="Order Pending" />

            <section className="py-5">
                <div className="container text-center">
                    <Suspense fallback={<div>Loading...</div>}>
                        <OrderPendingClient />
                    </Suspense>
                </div>
            </section>
        </>
    );
}
