import React, { Suspense } from "react";
import InnerBanner from "@/components/InnerBanner";
import OrderSuccessClient from "@/components/OrderSuccessClient";

export default function OrderSuccessPage() {
    return (
        <>
            <style>{`
                .order-status-card {
                    background: #fff;
                    border-radius: 12px;
                    padding: 40px;
                    max-width: 500px;
                    margin: auto;
                    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
                }

                .order-status-card.success {
                    border-top: 6px solid #28a745;
                }
            `}</style>

            <InnerBanner title="Order Successful" breadcrumb="Order Success" />

            <section className="py-5">
                <div className="container text-center">
                    <Suspense fallback={<div>Loading...</div>}>
                        <OrderSuccessClient />
                    </Suspense>
                </div>
            </section>
        </>
    );
}
