"use client";

import { useEffect } from "react";

/**
 * Loads Bootstrap and Font Awesome CSS only when mounted on client
 * Use this component on pages that need Bootstrap styling
 */
export default function BootstrapLoader() {
    useEffect(() => {
        // Load Font Awesome
        if (!document.querySelector('link[href*="fontawesome"]')) {
            const faLink = document.createElement("link");
            faLink.rel = "stylesheet";
            faLink.href = "https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css";
            document.head.appendChild(faLink);
        }

        // Load Bootstrap
        if (!document.querySelector('link[href*="bootstrap.min.css"]')) {
            const bsLink = document.createElement("link");
            bsLink.rel = "stylesheet";
            bsLink.href = "https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css";
            document.head.appendChild(bsLink);
        }
    }, []);

    return null;
}
