"use client";

import Link from "next/link";
import { useRouter, usePathname, useSearchParams } from "next/navigation";

export default function BuyNowGate({
    isLoggedIn,
    handleBuyNow,
    isDisabled = false,
    variant = "button", // "button" | "login-block"
    preserveQuery = false, // true only if you need query params
}) {
    const router = useRouter();
    const pathname = usePathname();
    const searchParams = preserveQuery ? useSearchParams() : null;

    const fullPath =
        preserveQuery && searchParams?.toString()
        ? `${pathname}?${searchParams.toString()}`
        : pathname;

    const redirectUrl = `/login?redirect=${encodeURIComponent(fullPath)}&intent=buy_now`;

    // ---- Hard-copy page UI ----
    if (variant === "login-block") {
        return !isLoggedIn && (
            <div className="text-center p-5 border rounded-4 bg-light">
                <h4 className="mb-3">Login Required</h4>
                <p className="text-muted">
                    Please login to place your assignment order.
                </p>

                <button
                    className="btn btn-primary px-4"
                    onClick={() => router.push(redirectUrl)}
                >
                    Login to Continue
                </button>
            </div>
        );
    }

    // ---- Other pages UI ----
    return isLoggedIn ? (
        <button
            type="button"
            className="btn btn-light border w-50 fw-bold"
            onClick={handleBuyNow}
            disabled={isDisabled}
        >
            Buy Now
        </button>
    ) : (
        <Link
            href={redirectUrl}
            className="btn btn-light border w-50 fw-bold text-white"
            style={{
                backgroundColor: "#2f80ff",
                border: "none",
            }}
        >
            Buy Now
        </Link>
    );
}
