import Image from "next/image";
import "./FeaturesSection.css";

const features = [
    {
        icon: "/img/icon-1.png",
        text: "Verified Material for Higher Marks Is Less Time",
    },
    {
        icon: "/img/icon-2.png",
        text: "Purchase And Download Instantly",
    },
    {
        icon: "/img/icon-3.png",
        text: "Best Quality Material On Google",
    },
    {
        icon: "/img/icon-4.png",
        text: "Error Free No Grammatical And Spelling Mistakes",
    },
];

export default function FeaturesSection() {
    return (
        <section className="pb-5 features-sec">
            <div className="container">
                <div className="row">
                    {features.map((item, index) => (
                        <div className="col-lg-3 col-sm-6" key={index}>
                            <div className="features-box text-center">
                                <div className="features-icon mb-3">
                                    <Image
                                        src={item.icon}
                                        alt={item.text}
                                        width={60}
                                        height={60}
                                    />
                                </div>
                                <p className="m-0">{item.text}</p>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </section>
    );
}
