"use client";

import React from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay, Pagination } from "swiper/modules";
import "swiper/css";
import "swiper/css/pagination";
import styles from "./HeroSection.module.css";

type Slide = {
    id: string;
    title: string;
    subtitle: string;
    text: string;
    images: string[];
    ctaPrimary: {
        text: string;
        href: string;
    };
    ctaSecondary: {
        text: string;
        href: string;
    };
};

export default function HeroSection({
    data,
}: {
    data: Slide[];
}) {
    if (!data || data.length === 0) return null;

    return (
        <>
            <style>{`
        .banner-img {
          position: relative;
        }

        img.home-banner {
          width: 100% !important;
          height: 560px !important;
          object-fit: contain;
        }

        .banner-img:before {
          position: absolute;
          background-image: url(/img/hero-1-5.png);
          top: 0;
          left: 0;
          width: 300px;
          height: 300px;
          content: "";
          background-size: contain;
          background-repeat: no-repeat;
          z-index: -1;
          animation: rotate 55s linear infinite;
        }

        .banner-img:after {
          position: absolute;
          background-image: url(/img/hero-1-1.png);
          top: 100px;
          left: 100px;
          width: 400px;
          height: 400px;
          content: "";
          background-size: contain;
          background-repeat: no-repeat;
          z-index: -1;
        }

        @keyframes rotate {
          from {
            transform: rotate(0deg);
          }

          to {
            transform: rotate(360deg);
          }
        }
      `}</style>

            <section className={`${styles.heroSection} pt-5`}>
                <Swiper
                    loop={data.length > 1}
                    spaceBetween={0}
                    slidesPerView={1}
                    speed={1000}
                    autoplay={{ delay: 3000, disableOnInteraction: false }}
                    pagination={{ clickable: true }}
                    modules={[Autoplay, Pagination]}
                    className="hero-slider"
                >
                    {data.map((s) => (
                        <SwiperSlide key={s.id}>
                            <div className="container">
                                <div className="row align-items-center">
                                    {/* Left content */}
                                    <div className="col-lg-6 mb-4">
                                        <h1 className="fw-bold display-6">
                                            {s.title} <span className="text-primary" />
                                        </h1>
                                        <h4 className="fw-semibold mt-3">{s.subtitle}</h4>
                                        <div
                                            className="text-muted mt-3 lh-lg"
                                            dangerouslySetInnerHTML={{ __html: s.text }}
                                        />

                                        <div className="d-flex gap-3 mt-4">
                                            <a
                                                className="btn btn-primary px-4 rounded-pill"
                                                href={s.ctaPrimary.href}
                                            >
                                                {s.ctaPrimary.text}{" "}
                                                <i className="fa-solid fa-arrow-right ms-2" />
                                            </a>

                                            <a
                                                className="btn btn-outline-dark px-4 rounded-pill"
                                                href={s.ctaSecondary.href}
                                            >
                                                {s.ctaSecondary.text}{" "}
                                                <i className="fa-regular fa-circle-question ms-2" />
                                            </a>
                                        </div>
                                    </div>

                                    {/* Right images */}
                                    <div className="col-lg-6">
                                        <div className="d-flex flex-wrap gap-3 justify-content-center">
                                            <div className="banner-img">
                                                {s.images?.map((img, i) => (
                                                    <img
                                                        key={i}
                                                        src={img}
                                                        alt="Hero"
                                                        className="home-banner"
                                                    />
                                                ))}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </SwiperSlide>
                    ))}
                </Swiper>
            </section>
        </>
    );
}
