"use client";

import React from "react";
import "./IgnouCtaSection.css";

interface IgnouCtaSectionProps {
    data: {
        subsections: Array<{
            title: string;
            description?: string;
            link?: string;
        }>;
    };
}

export default function IgnouCtaSection({ data }: IgnouCtaSectionProps) {
    if (!data?.subsections || data.subsections.length === 0) return null;

    const [left, right] = data.subsections;

    return (
        <section className="ignou-cta-section">
            <div className="row g-0">
                {/* Left column */}
                {left && (
                    <div className="col-12 col-lg-6">
                        <div className="ignou-cta ignou-cta-left d-flex justify-content-between align-items-center">
                            <div className="ignou-cta-text mt-4">
                                <h2>{left.title}</h2>
                                {left.description && <p>{left.description}</p>}
                            </div>
                            <a href={left.link || "#"} className="ignou-cta-btn">
                                <span>
                                    <i className="fa-solid fa-angle-right"></i>
                                </span>
                            </a>
                        </div>
                    </div>
                )}

                {/* Right column */}
                {right && (
                    <div className="col-12 col-lg-6">
                        <div className="ignou-cta ignou-cta-right d-flex justify-content-between align-items-center">
                            <div className="ignou-cta-text">
                                <h2>{right.title}</h2>
                                {right.description && <p>{right.description}</p>}
                            </div>
                            <a href={right.link || "#"} className="ignou-cta-btn">
                                <span>
                                    <i className="fa-solid fa-angle-right"></i>
                                </span>
                            </a>
                        </div>
                    </div>
                )}
            </div>
        </section>
    );
}
