'use client';

import React, { useEffect } from "react";
import { useRouter, useSearchParams } from "next/navigation";
import { getToken } from "@/lib/apiEndpoints";
import Link from "next/link";

export default function OrderFailedClient() {
    const router = useRouter();
    const searchParams = useSearchParams();
    const message =
        searchParams.get("message") || "Something went wrong while placing your order.";

    const isLoggedIn = !!getToken();

    useEffect(() => {
        if (!isLoggedIn) {
            router.replace("/login");
        }
    }, [isLoggedIn, router]);

    return (
        <div className="order-status-card failed">
            <i className="fa-solid fa-circle-xmark fa-4x text-danger mb-3"></i>

            <h2 className="mb-2">Order Failed</h2>
            <p className="text-muted">{message}</p>

            <div className="mt-4 d-flex justify-content-center gap-3">
                <Link href="/checkout" className="btn btn-danger">
                    Try Again
                </Link>
                <Link href="/cart" className="btn btn-outline-secondary">
                    Back to Cart
                </Link>
            </div>
        </div>
    );
}
