'use client';

import React, { useEffect } from "react";
import { useRouter, useSearchParams } from "next/navigation";
import Link from "next/link";
import { getToken } from "@/lib/apiEndpoints";
import { useCart } from "@/context/CartContext";

export default function OrderSuccessClient() {
    const router = useRouter();
    const searchParams = useSearchParams();
    const { loadCart } = useCart();
    const isLoggedIn = !!getToken();
    const orderNumber = searchParams.get("order");

    // Redirect if not logged in
    useEffect(() => {
        if (!isLoggedIn) {
            router.replace("/login");
        }
    }, [isLoggedIn, router]);

    // Reload cart
    useEffect(() => {
        loadCart();
    }, [loadCart]);

    return (
        <div className="order-status-card success">
            <i className="fa-solid fa-circle-check fa-4x text-success mb-3"></i>

            <h2 className="mb-2">Thank You for Your Order!</h2>
            <p className="text-muted">
                Your order has been placed successfully.
            </p>

            {orderNumber && (
                <p className="fw-semibold mt-3">
                    Order Number: <span className="text-primary">{orderNumber}</span>
                </p>
            )}

            <div className="mt-4 d-flex justify-content-center gap-3">
                <Link href="/dashboard" className="btn btn-primary">
                    View Orders
                </Link>
                <Link href="/" className="btn btn-outline-secondary">
                    Continue Shopping
                </Link>
            </div>
        </div>
    );
}
