import { API_ENDPOINTS } from "@/lib/apiEndpoints";

export const getSiteStatus = async () => {
    try {
        const res = await API_ENDPOINTS.SITE_STATUS();

        if (!res.ok) {
            console.error("❌ API Status:", res.status);

            return {
                site_active: false,
                maintenance_mode: false,
            };
        }

        const data = await res.json();
        const status = Number(data.website_status);

        return {
            site_active: status === 1,
            maintenance_mode: status === 2,
        };
    } catch (error) {
        console.error("❌ Site status fetch failed:", error);

        return {
            site_active: false,
            maintenance_mode: false,
        };
    }
};
